#Copyright (C)  This program is free software: you can 
#redistribute it and/or modify it under the terms of the GNU General Public 
#License as published by the Free Software Foundation, either version 3 of the 
#License, or (at your option) any later version. This program is distributed in 
#the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the 
#implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
#GNU General Public License for more details.

#To obtain a copy of the general licence GNU General Public License contact 
#the Economic Regulation Authority at:
#Mail address PO Box 8469, PERTH BC WA 6849

#The GNU General Public License does not permit incorporating this program into proprietary programs. 
#---------------------------------------------------------------------------------------------------------

# File Name:     DRP automation.R

# Date:          2018-10-31

# Custodian:     Jason Dignard
# Role:          Principal Regulatory Advisor
# Authority:     Economic Regulation Authority
# Email:         jason.dignard @erawa.com.au

# Author:        Rohan Sadler
# Role:          Statistician
# Company:       Pink Lake Analytics
# Email:         rohan.sadler@pinklake.com.au


# libraries ------------------------------------------
#library(Rblpapi)
library(NMOF)
library(readxl)
library(sm)
library(mgcv)
#library(olsrr)
library(lubridate)
library(openxlsx)
library(YieldCurve)

# set working directory
## set working directory to level above where you have code;
##   or edit 'source' path below as required.
#setwd("~/DRP Methods")

# source files
source("code/drp_functions.R")

# inputs  --------------------------------------------
# data request and shaping
yieldData<-extractYield()

# estimation of each yield curve model
costDebt<-estimateCostOfDebt(inData=yieldData$yields,sigma=yieldData$gkSigma)

# shape model estimates into a debt risk premium estimate
#  refactor as a separate function when required.
yieldsDF<-as.data.frame(yieldData$yieldMatrix)
#names(yieldsDF)<-format(yieldData$tradingPeriod$Date,"%Y-%m-%d")
#yieldsDF<-cbind(bond=yieldData$bonds,yieldData$yields,yieldsDF)

outputDF<-cbind(
  c("Determination Date","Credit Rating","Averaging Period (days)",
    "Target Tenor (year)",NA,"Semi-annual yield",NA,"Gaussian kernel",
"Effective Tenor","Gaussian kernel extrapolated to 10 years","Nadaraya-Watson",NA,
"Nelson-Siegel","Nelson-Siegel Svensson",NA,"Semi-annual average yield",NA,
"Annual Yield","Gaussien kernel extrapolated to 10 years","Nelson-Siegel",
"Nelson-Siegel Svensson",NA,"Annual average yield",NA,"10 year IRS Rate",
"10 year Debt Risk Premium"),
 c(as.character(yieldData$determinationDate),yieldData$creditRating,
   yieldData$nTradingDays,yieldData$targetTenor,rep(NA,22)),
 rep(NA,26),rep(NA,26),rep(NA,26),rep(NA,26),rep(NA,26),
c(rep(NA,4),"Gaussian Kernel Calculator","Target Tenor","Target Tenor Yield",
  "Effective Tenor",NA,"Nelson-Siegel Optimal Parameters","Beta 0","Beta 1",
  "Beta 2","Lambda",NA,"Nelson-Siegel Svensson Optimal Parameters","Beta 0","Beta 1",
  "Beta 2","Beta 3","Lambda 1","Lambda 2",NA,"Contingency measures",
  "Support measure","STDEV of 3 estimates"),
rep(NA,26)
)

outputDF[7,2:5]<-c(3,5,7,10)

outputDF[8,2:5]<-costDebt$kernelRBA[,2]
outputDF[9,2:5]<-costDebt$kernelRBA[,1]

extrapolatedYields<-c(costDebt$kernelRBA[1:3,2],calcKernel10yrExtapolation(costDebt$kernelRBA))
outputDF[10,2:5]<- extrapolatedYields

outputDF[11,2:5]<-costDebt$solutions[,1]
outputDF[13,2:5]<-costDebt$solutions[,2]
outputDF[14,2:5]<-costDebt$solutions[,3]

adjustedSolutions<-cbind(extrapolatedYields,costDebt$solutions[,-1])
outputDF[16,2:5]<-apply(adjustedSolutions,1,mean)

annualisedCostDebt<-annualiseCOD(adjustedSolutions)

outputDF[19:21,2:5]<-t(annualisedCostDebt)

outputDF[6:8,9]<- outputDF[7:9,5]
outputDF[11:14,9] <- costDebt$NSparameters
outputDF[17:22,9] <- costDebt$NSSparameters[-length(costDebt$NSSparameters)]

outputDF[23,2:5]<-apply(annualisedCostDebt,1,mean)
outputDF[25,5]<-yieldData$IRS
outputDF[26,5]<-as.numeric(outputDF[23,5])-yieldData$IRS

outputDF[25,9]<-measureSupport(yieldData$yields$tenor,h=yieldData$gkSigma)
outputDF[26,9]<-sd(as.numeric(outputDF[19:21,5]))

outputDF<-as.character(outputDF)
outputDF<-matrix(ifelse(outputDF=="NA" | is.na(outputDF),"",outputDF),ncol=9)

outputDF<-as.data.frame(outputDF)

#fName<- readline(prompt="Enter file name of file to be saved (without path): ")
fString<-unlist(strsplit(yieldData$chosenFile,".xls",fixed=TRUE))[1]
fString<-paste0(fString,"_output.xlsx")

fList<-list(Output=outputDF ,Daily_yield=yieldsDF)

# allow for a function here to format the output excel workbook into
#  a more human readable format.

cat("Your output file has been saved as ",fString,"\n")

#write.xlsx(fListd,fString ,asTable=TRUE,colNames=c(FALSE,TRUE),overwrite=TRUE)
write.xlsx(fList$Output,fString ,asTable=TRUE,colNames=FALSE,overwrite=TRUE)


#------------------
# Develop option to write out entire workbook through openxlsx
#    This would format the R page
#    And insert it into the start of workbook
# wb <- loadWorkbook(fChoose)
# addWorksheet(wb,"DRP output using R")
# 
# writeDataTable(wb, "DRP output using R",x=outputDF,colNames=FALSE)
# # Save file
# saveWorkbook(wb, file = fChoose,overwrite=TRUE)
